﻿/*
VERSION:
	1.1
	
DESCRIPTION:
	This is a handy function.  After loading an XML file, 
	use this to locate a specific tag so you can read its attributes.

WHAT IT'S FOR:
	This searches an XML object for the specified tag, and returns a reference to that tag.
	
USAGE:
	#include "findXmlTag.as"
	myData_xml = findXmlTag( "myTag", my_xml );
	
WHAT IT IS:
	A function containing a search loop.
	It returns an XMLNode reference to the data it's asked to find.
	If it does not find the tag you want, it naturally returns "undefined"
*/



findXmlTag = function( findThis, this_xml )
{
	
	for (var i = 0; i < this_xml.childNodes.length; i++)
	{
		var dataName = this_xml.childNodes[i].nodeName;
		if (dataName == findThis){
			var foundTag_xml:XMLNode = this_xml.childNodes[i];
			break;
		}// if = findThis
	}// for i to childNodes.length
	
	return foundTag_xml;
}// findXmlTag()